/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.mapperbase.world.level.block.ToolTiers;
import tv.mapper.mapperbase.world.level.block.ToolTypes;
import tv.mapper.roadstuff.world.level.block.RotatableBlock;

public class BollardBlock
extends RotatableBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape EUR_BOLLARD_N = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)10.0, (double)16.0, (double)9.0);
    private static final VoxelShape EUR_BOLLARD_E = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)10.0);
    private static final VoxelShape EUR_BOLLARD_S = Block.m_49796_((double)6.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EUR_BOLLARD_W = Block.m_49796_((double)7.0, (double)0.0, (double)6.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EUR_SMALL_BOLLARD_N = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)8.0);
    private static final VoxelShape EUR_SMALL_BOLLARD_E = Block.m_49796_((double)8.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0);
    private static final VoxelShape EUR_SMALL_BOLLARD_S = Block.m_49796_((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)8.0, (double)9.0);
    private static final VoxelShape EUR_SMALL_BOLLARD_W = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)9.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private boolean small = false;

    public BollardBlock(BlockBehaviour.Properties properties, ToolTypes tool, boolean small) {
        super(properties, tool);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.small = small;
    }

    public BollardBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier, boolean small) {
        super(properties, tool, tier);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.small = small;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (this.small) {
            switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                case NORTH: {
                    return EUR_SMALL_BOLLARD_N;
                }
                case EAST: {
                    return EUR_SMALL_BOLLARD_E;
                }
                case SOUTH: {
                    return EUR_SMALL_BOLLARD_S;
                }
                case WEST: {
                    return EUR_SMALL_BOLLARD_W;
                }
            }
            return EUR_SMALL_BOLLARD_N;
        }
        switch ((Direction)state.m_61143_((Property)DIRECTION)) {
            case NORTH: {
                return EUR_BOLLARD_N;
            }
            case EAST: {
                return EUR_BOLLARD_E;
            }
            case SOUTH: {
                return EUR_BOLLARD_S;
            }
            case WEST: {
                return EUR_BOLLARD_W;
            }
        }
        return EUR_BOLLARD_N;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return BollardBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState FluidState2 = context.m_43725_().m_6425_(blockpos);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION}).m_61104_(new Property[]{WATERLOGGED});
    }
}

